(define/contract (expressive-words s words)
  (-> string? (listof string?) exact-integer?)
  (define (rle str)
    (let loop ([chars (string->list str)] [prev #f] [count 0] [res '()])
      (if (null? chars)
          (reverse (if prev (cons (cons prev count) res) res))
          (let ([c (car chars)])
            (if (equal? c prev)
                (loop (cdr chars) prev (add1 count) res)
                (loop (cdr chars) c 1 (if prev (cons (cons prev count) res) res)))))))

  (define s-rle (rle s))
  (define (check word)
    (define word-rle (rle word))
    (and (= (length s-rle) (length word-rle))
         (for/and ([s-pair s-rle] [w-pair word-rle])
           (and (equal? (car s-pair) (car w-pair))
                (or (= (cdr s-pair) (cdr w-pair))
                    (and (>= (cdr s-pair) 3) (>= (cdr s-pair) (cdr w-pair))))))))

  (count check words))