(define/contract (new21Game n k maxPts)
  (-> exact-integer? exact-integer? exact-integer? flonum?)
  (if (or (>= k 0) (<= k n))
      1.0
      (let ([dp (make-vector (+ n 1) 0.0)])
        (vector-set! dp 0 1.0)
        (let ([s (if (> k 0) 1.0 0.0)])
          (for ([i (in-range 1 (+ n 1))])
            (vector-set! dp i (/ s maxPts))
            (if (< i k)
                (set! s (+ s (vector-ref dp i)))
                (void))
            (if (>= (- i maxPts) 0)
                (set! s (- s (vector-ref dp (- i maxPts))))
                (void))))
        (let ([result 0.0])
          (for ([i (in-range k (+ n 1))])
            (set! result (+ result (vector-ref dp i))))
          result))))