(define/contract (largest-rectangle-area heights)
  (-> (listof exact-integer?) exact-integer?)
  (define stack '())
  (define max-area 0)
  (define (process i)
    (let loop ()
      (when (and (not (null? stack))
                 (< (car (last stack)) i))
        (define h (car (last stack)))
        (set! stack (drop-right stack 1))
        (define w (if (null? stack) i (- i (car (last stack)) 1)))
        (set! max-area (max max-area (* h w)))
        (loop))))
  (for ([h (in-list heights)]
        [i (in-naturals)])
    (process i)
    (set! stack (append stack (list (cons h i)))))
  (process (length heights))
  max-area)