(define (can-visit-all-rooms rooms)
  (let ([visited (make-vector (length rooms) #f)]
        [stack (list 0)])
    (vector-set! visited 0 #t)
    (let loop ()
      (if (null? stack)
          (foldl (lambda (x acc) (and x acc)) #t (vector->list visited))
          (let ([current (car stack)])
            (set! stack (cdr stack))
            (for-each (lambda (key)
                        (when (not (vector-ref visited key))
                          (vector-set! visited key #t)
                          (set! stack (cons key stack))))
                      (list-ref rooms current))
            (loop))))))