(define/contract (backspace-compare s t)
  (-> string? string? boolean?)
  (define (process-string str)
    (let loop ([chars (string->list str)] [stack '()])
      (if (null? chars)
          (list->string (reverse stack))
          (let ([c (car chars)])
            (if (char=? c #\#)
                (loop (cdr chars) (if (null? stack) stack (cdr stack)))
                (loop (cdr chars) (cons c stack)))))))
  (string=? (process-string s) (process-string t)))