(define/contract (shifting-letters s shifts)
  (-> string? (listof exact-integer?) string?)
  (define n (string-length s))
  (define shift-vec (make-vector n 0))
  (define total 0)
  (for ([i (in-range (sub1 n) -1 -1)])
    (set! total (modulo (+ total (list-ref shifts i)) 26))
    (vector-set! shift-vec i total))
  (define result (make-string n))
  (for ([i (in-range n)])
    (define c (char->integer (string-ref s i)))
    (define shifted (modulo (+ (- c 97) (vector-ref shift-vec i)) 26))
    (string-set! result i (integer->char (+ shifted 97))))
  result)