(define/contract (loud-and-rich richer quiet)
  (-> (listof (listof exact-integer?)) (listof exact-integer?) (listof exact-integer?))
  (define n (length quiet))
  (define graph (make-vector n '()))
  (for ([edge richer])
    (let ([a (second edge)] [b (first edge)])
      (vector-set! graph a (cons b (vector-ref graph a)))))
  (define answer (make-vector n -1))
  (define (dfs person)
    (if (not (= (vector-ref answer person) -1))
        (vector-ref answer person)
        (let ([min-quiet person])
          (for ([neighbor (vector-ref graph person)])
            (let ([candidate (dfs neighbor)])
              (when (< (list-ref quiet candidate) (list-ref quiet min-quiet))
                (set! min-quiet candidate))))
          (vector-set! answer person min-quiet)
          min-quiet)))
  (for ([i (in-range n)])
    (dfs i))
  (vector->list answer))