(define/contract (reordered-power-of-2 n)
  (-> exact-integer? boolean?)
  (let* ((s (number->string n))
         (len (string-length s))
         (digits (string->list s))
         (sorted-n (sort digits char<?)))
    (define (is-power-of-2? num)
      (and (> num 0) (= (bitwise-and num (- num 1)) 0)))
    (define (permute lst)
      (if (null? lst)
          '(())
          (apply append
                 (map (lambda (x)
                        (map (lambda (y) (cons x y))
                             (permute (remove x lst))))
                      lst)))
    (let ((perms (permute digits)))
      (ormap (lambda (p)
               (let ((num-str (list->string p)))
                 (and (not (char=? (string-ref num-str 0) #\0))
                      (is-power-of-2? (string->number num-str)))))
             perms))))