(define/contract (spiral-matrix-iii rows cols rStart cStart)
  (-> exact-integer? exact-integer? exact-integer? exact-integer? (listof (listof exact-integer?)))
  (define directions '((0 1) (1 0) (0 -1) (-1 0)))
  (define (valid? r c) (and (>= r 0) (< r rows) (>= c 0) (< c cols)))
  (let loop ([r rStart] [c cStart] [dir 0] [steps 1] [result '()])
    (if (>= (length result) (* rows cols))
        (reverse result)
        (let ([new-result (if (valid? r c) (cons (list r c) result) result)])
          (if (zero? (modulo dir 2))
              (loop (+ r (car (list-ref directions (modulo (add1 dir) 4))))
                   (+ c (cadr (list-ref directions (modulo (add1 dir) 4)))
                   (add1 dir)
                   (if (zero? (modulo dir 2)) steps (add1 steps))
                   new-result)
              (loop (+ r (car (list-ref directions dir)))
                   (+ c (cadr (list-ref directions dir)))
                   dir
                   steps
                   new-result))))))