#lang racket

(define/contract (surface-area grid)
  (-> (listof (listof exact-integer?)) exact-integer?)
  (define rows (length grid))
  (define cols (if (null? grid) 0 (length (car grid))))
  (define total 0)
  (for ([i (in-range rows)])
    (for ([j (in-range cols)])
      (define h (list-ref (list-ref grid i) j))
      (when (> h 0)
        (set! total (+ total (* 4 h) 2))
      (when (> i 0)
        (define up (list-ref (list-ref grid (- i 1)) j))
        (set! total (- total (* 2 (min h up)))))
      (when (> j 0)
        (define left (list-ref (list-ref grid i) (- j 1)))
        (set! total (- total (* 2 (min h left)))))))
  total)