(define/contract (word-subsets words1 words2)
  (-> (listof string?) (listof string?) (listof string?))
  (define (count-letters word)
    (define cnt (make-vector 26 0))
    (for ([c (in-string word)])
      (vector-set! cnt (- (char->integer c) 97) (add1 (vector-ref cnt (- (char->integer c) 97)))))
    cnt)

  (define max-b (make-vector 26 0))
  (for ([b (in-list words2)])
    (define cnt (count-letters b))
    (for ([i (in-range 26)])
      (vector-set! max-b i (max (vector-ref max-b i) (vector-ref cnt i)))))

  (define res '())
  (for ([a (in-list words1)])
    (define cnt-a (count-letters a))
    (define universal? #t)
    (for ([i (in-range 26)])
      (when (< (vector-ref cnt-a i) (vector-ref max-b i))
        (set! universal? #f)
        (break)))
    (when universal?
      (set! res (cons a res))))
  (reverse res))