(define/contract (max-subarray-sum-circular nums)
  (-> (listof exact-integer?) exact-integer?)
  (define n (length nums))
  (define total (apply + nums))
  (define (kadane nums op)
    (let loop ([i 1] [current (car nums)] [result (car nums)])
      (if (= i n)
          result
          (let ([current (op (list-ref nums i) (+ current (list-ref nums i)))])
            (loop (+ i 1) current (op result current))))))
  (define max-sum (kadane nums max))
  (define min-sum (kadane nums min))
  (if (> max-sum 0)
      (max max-sum (- total min-sum))
      max-sum))