#lang racket

(define/contract (min-malware-spread graph initial)
  (-> (listof (listof exact-integer?)) (listof exact-integer?) exact-integer?)
  (define n (length graph))
  (define parent (make-vector n 0))
  (define size (make-vector n 1))

  (for ([i (in-range n)])
    (vector-set! parent i i))

  (define (find u)
    (if (= (vector-ref parent u) u)
        u
        (begin
          (vector-set! parent u (find (vector-ref parent u)))
          (vector-ref parent u)))

  (define (union u v)
    (define root-u (find u))
    (define root-v (find v))
    (when (not (= root-u root-v))
      (if (< (vector-ref size root-u) (vector-ref size root-v))
          (begin
            (vector-set! parent root-u root-v)
            (vector-set! size root-v (+ (vector-ref size root-v) (vector-ref size root-u))))
          (begin
            (vector-set! parent root-v root-u)
            (vector-set! size root-u (+ (vector-ref size root-u) (vector-ref size root-v)))))))

  (for ([i (in-range n)])
    (for ([j (in-range n)])
      (when (= (list-ref (list-ref graph i) j) 1)
        (union i j))))

  (define count (make-hash))
  (for ([node initial])
    (define root (find node))
    (hash-update! count root (lambda (v) (+ v 1)) 0))

  (define result -1)
  (define max-size -1)
  (for ([node (sort initial <)])
    (define root (find node))
    (if (= (hash-ref count root) 1)
        (if (> (vector-ref size root) max-size)
            (begin
              (set! max-size (vector-ref size root))
              (set! result node))
            (void))
        (void)))

  (if (= result -1)
      (apply min initial)
      result))