(define (min-malware-spread graph initial)
  (define n (vector-length graph))
  (define initial-set (list->set initial))
  (define (bfs node infected)
    (define visited (make-hash))
    (define q (make-queue))
    (hash-set! visited node #t)
    (enqueue! q node)
    (define count 0)
    (let loop ()
      (unless (queue-empty? q)
        (define current (dequeue! q))
        (set! count (add1 count))
        (for ([neighbor (in-range n)]
              #:when (and (positive? (vector-ref (vector-ref graph current) neighbor))
                          (not (hash-ref visited neighbor #f))
                          (not (set-member? infected neighbor))))
          (hash-set! visited neighbor #t)
          (enqueue! q neighbor))
        (loop)))
    count)

  (define (simulate-removal removed)
    (define infected (set-remove initial-set removed))
    (define total-infected 0)
    (define visited (make-hash))
    (for ([node (in-set infected)])
      (unless (hash-ref visited node #f)
        (define cnt (bfs node infected))
        (set! total-infected (+ total-infected cnt))
        (for ([i (in-range n)]
              #:when (and (positive? (vector-ref (vector-ref graph node) i))
                          (not (set-member? infected i))))
          (hash-set! visited i #t))))
    total-infected)

  (define min-infected (simulate-removal (car initial)))
  (define result (car initial))
  (for ([node (in-list (cdr initial))])
    (define current-infected (simulate-removal node))
    (cond
      [(< current-infected min-infected)
       (set! min-infected current-infected)
       (set! result node)]
      [(and (= current-infected min-infected) (< node result))
       (set! result node)]))
  result)