(define/contract (min-falling-path-sum matrix)
  (-> (listof (listof exact-integer?)) exact-integer?)
  (let* ([n (length matrix)]
         [dp (make-vector n (make-vector n 0))])
    (for ([i (in-range n)])
      (vector-set! (vector-ref dp 0) i (list-ref (list-ref matrix 0) i)))
    (for ([i (in-range 1 n)])
      (for ([j (in-range n)])
        (let ([min-val (vector-ref (vector-ref dp (- i 1)) j)])
          (when (> j 0)
            (set! min-val (min min-val (vector-ref (vector-ref dp (- i 1)) (- j 1)))))
          (when (< j (- n 1))
            (set! min-val (min min-val (vector-ref (vector-ref dp (- i 1)) (+ j 1)))))
          (vector-set! (vector-ref dp i) j (+ (list-ref (list-ref matrix i) j) min-val)))))
    (apply min (vector->list (vector-ref dp (- n 1))))))