(define (shortest-superstring words)
  (define n (length words))
  (when (= n 0) (return ""))
  (define overlaps (make-vector n (make-vector n 0)))
  (for ([i (in-range n)])
    (for ([j (in-range n)])
      (when (not (= i j))
        (vector-set! (vector-ref overlaps i) j (overlap (list-ref words i) (list-ref words j))))))

  (define dp (make-vector (expt 2 n) (make-vector n "")))
  (define parent (make-vector (expt 2 n) (make-vector n -1)))

  (for ([mask (in-range 1 (expt 2 n))])
    (for ([bit (in-range n)])
      (when (not (zero? (bitwise-and mask (bitwise-arithmetic-shift-left 1 bit))))
        (define prev-mask (bitwise-xor mask (bitwise-arithmetic-shift-left 1 bit)))
        (when (zero? prev-mask)
          (vector-set! (vector-ref dp mask) bit (list-ref words bit))
          (vector-set! (vector-ref parent mask) bit -1)
        (else
          (for ([i (in-range n)])
            (when (not (zero? (bitwise-and prev-mask (bitwise-arithmetic-shift-left 1 i))))
              (define new-str (string-append (vector-ref (vector-ref dp prev-mask) i)
                                           (substring (list-ref words bit)
                                                      (vector-ref (vector-ref overlaps i) bit))))
              (when (or (string=? (vector-ref (vector-ref dp mask) bit) "")
                      (< (string-length new-str) (string-length (vector-ref (vector-ref dp mask) bit))))
                (vector-set! (vector-ref dp mask) bit new-str)
                (vector-set! (vector-ref parent mask) bit i)))))))))

  (define mask (sub1 (expt 2 n)))
  (define last (argmin (lambda (i) (string-length (vector-ref (vector-ref dp mask) i))) (range n)))
  (define path '())
  (define current last)
  (define current-mask mask)

  (while (>= current 0)
    (set! path (cons current path))
    (define prev (vector-ref (vector-ref parent current-mask) current))
    (when (>= prev 0)
      (set! current-mask (bitwise-xor current-mask (bitwise-arithmetic-shift-left 1 current))))
    (set! current prev))

  (define result (vector-ref (vector-ref dp mask) last))
  result)

(define (overlap a b)
  (define max-len (min (string-length a) (string-length b)))
  (define max-overlap 0)
  (for ([k (in-range 1 (add1 max-len))])
    (when (string=? (substring a (- (string-length a) k)) (substring b 0 k))
      (set! max-overlap k)))
  max-overlap)