(define/contract (vertical-traversal root)
  (-> (or/c null? tree-node?) (listof (listof exact-integer?)))
  (if (null? root)
      '()
      (let ([ht (make-hash)])
        (let loop ([node root] [col 0] [row 0])
          (when (not (null? node))
            (hash-update! ht col
                          (lambda (lst) (cons (cons row (tree-node-val node)) lst)
                          '())
            (loop (tree-node-left node) (sub1 col) (add1 row))
            (loop (tree-node-right node) (add1 col) (add1 row))))
        (let* ([cols (sort (hash-keys ht) <)]
               [sorted-cols (map (lambda (col)
                                  (sort (hash-ref ht col)
                                        (lambda (a b)
                                          (or (< (car a) (car b))
                                              (and (= (car a) (car b))
                                                   (< (cdr a) (cdr b)))))))
                                cols)])
          (map (lambda (lst) (map cdr lst)) sorted-cols)))))