(define (equations-possible equations)
  (let ((parent (make-vector 26)))
    (define (find x)
      (if (not (= (vector-ref parent x) x))
          (begin
            (vector-set! parent x (find (vector-ref parent x)))
            (vector-ref parent x))
          x))
    (define (union x y)
      (let ((root-x (find x))
            (root-y (find y)))
        (vector-set! parent root-x root-y)))
    (for ([i 26]) (vector-set! parent i i))
    (for ([eq equations])
      (let ((x (- (char->integer (string-ref eq 0)) 97))
            (y (- (char->integer (string-ref eq 3)) 97)))
            (op (string-ref eq 1)))
        (when (char=? op #\=)
          (union x y))))
    (for/and ([eq equations])
      (let ((x (- (char->integer (string-ref eq 0)) 97))
            (y (- (char->integer (string-ref eq 3)) 97)))
        (if (char=? (string-ref eq 1) #\!)
            (not (= (find x) (find y)))
            #t))))
)