#lang racket

(define (oranges-rotting grid)
  (define rows (length grid))
  (define cols (if (null? grid) 0 (length (car grid))))
  (define directions '((0 1) (1 0) (0 -1) (-1 0)))
  (define queue (make-queue))
  (define fresh-count 0)
  (define minutes 0)

  (for ([i (in-range rows)])
    (for ([j (in-range cols)])
      (define cell (list-ref (list-ref grid i) j))
      (cond
        [(= cell 2) (enqueue! queue (cons i j))]
        [(= cell 1) (set! fresh-count (add1 fresh-count))])))

  (define (bfs)
    (let loop ()
      (define size (queue-length queue))
      (when (and (> size 0) (> fresh-count 0))
        (set! minutes (add1 minutes))
        (for ([_ (in-range size)])
          (define current (dequeue! queue))
          (define i (car current))
          (define j (cdr current))
          (for ([dir directions])
            (define ni (+ i (car dir)))
            (define nj (+ j (cadr dir)))
            (when (and (>= ni 0) (< ni rows) (>= nj 0) (< nj cols)
                     (= (list-ref (list-ref grid ni) nj) 1))
              (set! fresh-count (sub1 fresh-count))
              (list-set! (list-ref grid ni) nj 2)
              (enqueue! queue (cons ni nj)))))
        (loop))))

  (bfs)
  (if (= fresh-count 0) minutes -1))

(define (make-queue) (mcons null null))
(define (enqueue! q x)
  (if (null? (mcar q))
      (begin (set-mcar! q (mcons x null)) (set-mcdr! q (mcar q)))
      (begin (set-mcdr! (mcdr q) (mcons x null)) (set-mcdr! q (mcdr (mcdr q))))))
(define (dequeue! q)
  (define front (mcar (mcar q)))
  (set-mcar! q (mcdr (mcar q)))
  (when (null? (mcar q)) (set-mcdr! q null))
  front)
(define (queue-length q)
  (let loop ([lst (mcar q)] [count 0])
    (if (null? lst) count (loop (mcdr lst) (add1 count)))))