struct UnionFind {
    parent: Vec<usize>,
}

impl UnionFind {
    fn new(size: usize) -> Self {
        let parent = (0..size).collect();
        UnionFind { parent }
    }

    fn find(&mut self, x: usize) -> usize {
        if self.parent[x] != x {
            self.parent[x] = self.find(self.parent[x]);
        }
        self.parent[x]
    }

    fn union(&mut self, x: usize, y: usize) {
        let root_x = self.find(x);
        let root_y = self.find(y);
        if root_x != root_y {
            if root_x < root_y {
                self.parent[root_y] = root_x;
            } else {
                self.parent[root_x] = root_y;
            }
        }
    }
}

impl Solution {
    pub fn smallest_equivalent_string(s1: String, s2: String, base_str: String) -> String {
        let mut uf = UnionFind::new(26);
        let s1_chars: Vec<char> = s1.chars().collect();
        let s2_chars: Vec<char> = s2.chars().collect();

        for i in 0..s1_chars.len() {
            let c1 = s1_chars[i] as usize - 'a' as usize;
            let c2 = s2_chars[i] as usize - 'a' as usize;
            uf.union(c1, c2);
        }

        let mut result = String::new();
        for c in base_str.chars() {
            let idx = c as usize - 'a' as usize;
            let root = uf.find(idx);
            result.push((root as u8 + b'a') as char);
        }

        result
    }
}