use std::collections::HashMap;

impl Solution {
    pub fn sum_of_unique(nums: Vec<i32>) -> i32 {
        let mut freq = HashMap::new();
        for &num in &nums {
            *freq.entry(num).or_insert(0) += 1;
        }
        freq.iter()
            .filter(|&(_, &count)| count == 1)
            .map(|(&num, _)| num)
            .sum()
    }
}