impl Solution {
    pub fn count_submatrices(grid: Vec<Vec<i32>>, k: i32) -> i32 {
        let m = grid.len();
        let n = grid[0].len();
        let mut prefix = vec![vec![0; n]; m];
        let mut res = 0;

        for i in 0..m {
            for j in 0..n {
                let mut sum = grid[i][j];
                if i > 0 {
                    sum += prefix[i-1][j];
                }
                if j > 0 {
                    sum += prefix[i][j-1];
                }
                if i > 0 && j > 0 {
                    sum -= prefix[i-1][j-1];
                }
                prefix[i][j] = sum;
                if sum <= k {
                    res += 1;
                }
            }
        }
        res
    }
}