use std::collections::HashSet;

impl Solution {
    pub fn min_malware_spread(graph: Vec<Vec<i32>>, initial: Vec<i32>) -> i32 {
        let n = graph.len();
        let mut initial = initial;
        initial.sort_unstable();
        let initial_set: HashSet<i32> = initial.iter().cloned().collect();
        let mut parent = (0..n as i32).collect::<Vec<_>>();
        let mut size = vec![1; n];

        for i in 0..n {
            for j in i + 1..n {
                if graph[i][j] == 1 {
                    Self::union(i as i32, j as i32, &mut parent, &mut size);
                }
            }
        }

        let mut infected_count = vec![0; n];
        for &node in &initial {
            let root = Self::find(node, &mut parent);
            infected_count[root as usize] += 1;
        }

        let mut result = initial[0];
        let mut max_size = 0;

        for &node in &initial {
            let root = Self::find(node, &mut parent);
            if infected_count[root as usize] == 1 {
                if size[root as usize] > max_size {
                    max_size = size[root as usize];
                    result = node;
                } else if size[root as usize] == max_size && node < result {
                    result = node;
                }
            }
        }

        if max_size != 0 {
            return result;
        }

        initial[0]
    }

    fn find(x: i32, parent: &mut Vec<i32>) -> i32 {
        if parent[x as usize] != x {
            parent[x as usize] = Self::find(parent[x as usize], parent);
        }
        parent[x as usize]
    }

    fn union(x: i32, y: i32, parent: &mut Vec<i32>, size: &mut Vec<usize>) {
        let root_x = Self::find(x, parent);
        let root_y = Self::find(y, parent);
        if root_x != root_y {
            if size[root_x as usize] < size[root_y as usize] {
                parent[root_x as usize] = root_y;
                size[root_y as usize] += size[root_x as usize];
            } else {
                parent[root_y as usize] = root_x;
                size[root_x as usize] += size[root_y as usize];
            }
        }
    }
}