use std::collections::{HashSet, HashMap};

impl Solution {
    pub fn min_malware_spread(graph: Vec<Vec<i32>>, initial: Vec<i32>) -> i32 {
        let n = graph.len();
        let mut initial = initial;
        initial.sort_unstable();
        let initial_set: HashSet<_> = initial.iter().cloned().collect();
        let mut parent = (0..n).collect::<Vec<_>>();
        let mut size = vec![1; n];

        fn find(u: usize, parent: &mut Vec<usize>) -> usize {
            if parent[u] != u {
                parent[u] = find(parent[u], parent);
            }
            parent[u]
        }

        fn union(u: usize, v: usize, parent: &mut Vec<usize>, size: &mut Vec<usize>) {
            let root_u = find(u, parent);
            let root_v = find(v, parent);
            if root_u != root_v {
                if size[root_u] > size[root_v] {
                    parent[root_v] = root_u;
                    size[root_u] += size[root_v];
                } else {
                    parent[root_u] = root_v;
                    size[root_v] += size[root_u];
                }
            }
        }

        for u in 0..n {
            if initial_set.contains(&(u as i32)) {
                continue;
            }
            for v in 0..n {
                if initial_set.contains(&(v as i32)) {
                    continue;
                }
                if graph[u][v] == 1 {
                    union(u, v, &mut parent, &mut size);
                }
            }
        }

        let mut infected_counts = HashMap::new();
        let mut root_to_malware = HashMap::new();
        for &mal in initial.iter() {
            let mal = mal as usize;
            let mut infected_roots = HashSet::new();
            for v in 0..n {
                if graph[mal][v] == 1 && !initial_set.contains(&(v as i32)) {
                    infected_roots.insert(find(v, &mut parent));
                }
            }
            for &root in infected_roots.iter() {
                *infected_counts.entry(root).or_insert(0) += 1;
            }
            root_to_malware.insert(mal, infected_roots);
        }

        let mut max_saved = -1;
        let mut result = initial[0];
        for &mal in initial.iter() {
            let mal = mal as usize;
            let mut saved = 0;
            for &root in root_to_malware.get(&mal).unwrap() {
                if infected_counts.get(&root).unwrap() == &1 {
                    saved += size[root];
                }
            }
            if saved > max_saved || (saved == max_saved && mal as i32 < result) {
                max_saved = saved;
                result = mal as i32;
            }
        }

        result
    }
}