# Task-Driven Token Reduction for Accelerated ViT in Robotic Navigation

This repository contains the implementation of our method described in the paper:

**"Seeing Like Humans: Task-Driven Token Reduction for Accelerated ViT in Robotic Navigation"**

Our method is developed based on the [EAI-VC](https://github.com/facebookresearch/eai-vc) codebase. Please follow the instructions in the original EAI-VC repository to set up the environment and prepare the datasets.

## 🔧 Environment Setup & Dataset

To build the environment and download the required datasets, please refer to the original [EAI-VC README](https://github.com/facebookresearch/eai-vc#readme). This includes setting up Habitat and downloading CortexBench trajectories.

## 📁 Project Structure

Our method is implemented under the following path:

```
cortexbench/habitat_vc/
```

Key scripts:

- `train.sh`: script to train the ViT-based policy with task-driven token pruning.
- `testing.sh`: script to evaluate performance (e.g., SPL, Success Rate) on the validation sets.

The proposed model architecture and token reduction mechanism are implemented in:

```
vc_models\src\vc_models\models\vit\vit.py:SelectiveVisionTransformer
```

## 🚀 Training

To start training, run:

```bash
cd cortexbench/habitat_vc/distillation/
bash train.sh
```

## 📊 Testing

To evaluate the model, run:

```bash
cd cortexbench/habitat_vc/
bash test.sh
```

## 🔗 Acknowledgement

This repository is based on [EAI-VC](https://github.com/facebookresearch/eai-vc). We thank the authors for their excellent codebase.