import matplotlib.pyplot as plt

# 示例数据（横坐标 FPS，纵坐标 SR）
# 每个方法是一组 (FPS, SR) 的点
methods = {
    "EViT": {
        "fps": [54.1, 47.7, 41.4],
        "sr":  [6.3, 7.6, 41.8],
        "marker": "D"
    },
    "ToMe": {
        "fps": [48.3, 40.9, 38.5],
        "sr":  [18.5, 32.1, 50.7],
        "marker": "^"
    },
    "DynamicViT": {
        "fps": [53.8, 47.9, 41.3],
        "sr":  [16.4, 27.6, 46.4],
        "marker": "s"
    },
    "Ours": {
        "fps": [58.0, 57.5, 56.4, 52.5, 47.5],
        "sr":  [49.8, 50.0, 50.1, 51.4, 52.4],
        "marker": "o"
    },
}

baseline_fps = 37.4
baseline_sr = 52.1

plt.figure(figsize=(6,4))

plt.scatter(
    baseline_fps, baseline_sr,
    marker="*", s=200, color="blue", label="Baseline", zorder=5
)

# 绘制每个方法
for name, data in methods.items():
    plt.plot(
        data["fps"], data["sr"],
        marker='o', linewidth=2, markersize=6,
        label=name
    )

# 设置坐标轴
plt.xlabel("FPS", fontsize=12)
plt.ylabel("Success Rate (SR, %)", fontsize=12)
# plt.title("FPS-SR Trade-off", fontsize=14)

plt.grid(True, linestyle="--", alpha=0.5)
plt.legend()
plt.tight_layout()
plt.savefig("sr_fps_tradeoff.png", dpi=300)








plt.clf()
# 数据
thr_temp = [0.4, 0.5, 0.6]
sr_temp = [50.0, 50.1, 50.6]
fps_temp = [56.7, 56.4, 55.1]

thr_task = [0.4, 0.5, 0.6]
sr_task = [50.1, 50.1, 51.2]
fps_task = [57.0, 56.4, 53.6]

# 创建画布
plt.figure(figsize=(6,5))

# 绘制折线
plt.plot(fps_temp, sr_temp, marker='o', color='tab:blue', label=r'Varying $thr_{temp}$')
plt.plot(fps_task, sr_task, marker='s', color='tab:orange', label=r'Varying $thr_{task}$')

# 标注数据值
for x, y in zip(fps_temp, sr_temp):
    plt.text(x, y+0.15, f"({x:.1f}, {y:.1f})", fontsize=9, color='tab:blue', ha='center')

for x, y in zip(fps_task, sr_task):
    plt.text(x, y-0.35, f"({x:.1f}, {y:.1f})", fontsize=9, color='tab:orange', ha='center')

# 坐标轴和标题
plt.xlabel('FPS', fontsize=12)
plt.ylabel('Success Rate (SR, %)', fontsize=12)
plt.title('Effect of Thresholds on SR–FPS trade-off', fontsize=14)
plt.grid(True, linestyle='--', alpha=0.6)
plt.legend()

# 如果你想和左边图一样让 FPS 从小到大向右，可以默认；如果想反过来可启用下面：
# plt.gca().invert_xaxis()

plt.tight_layout()
plt.savefig("thresholds_effect.png", dpi=300)
