# Implementation of "Towards Category Unification of 3D Single Object Tracking on Point Clouds" for ICLR2024 double-blind review.

## Abstract

Current 3D single object tracking (SOT), regardless of Siamese or motion-centric paradigms, commonly relies on category-specific models to perform tracking task. However, such over-specialize model designs incur redundant parameters, thus limiting the broader applicability of 3D SOT task. This paper first introduces unified models that can simultaneously track objects across all categories using a single network with shared model parameters. Specifically, we propose to explicitly encode distinct attributes associated to different object categories, enabling the model to adapt to cross-category data. We discover that the attribute variances of point cloud objects primarily occur from the varying size and shape (\textit{e.g.}, large and square vehicles \textit{v.s.} small and slender humans). Based on this observation, we design a novel point set representation learning network inheriting transformer architecture, termed \textit{AdaFormer}, which adaptively encodes the dynamically varying shape and size information from cross-category data in a unified manner. Moreover, we incorporate the size and shape prior derived from the known template targets into the model’s inputs and learning objective, facilitating the learning of unified representation. Equipped with such designs, we construct two category-unified models SiamCUT and MoCUT, following the Siamese and motion-centric paradigms. Extensive experiments demonstrate that SiamCUT and MoCUT exhibit strong generalization and training stability. Furthermore, our category-unified models outperform the category-specific counterparts by a significant margin (\textit{e.g.}, on KITTI dataset, $\sim$12\% and $\sim$3\% performance gains on the Siamese and motion paradigms).

<img src="docs/CUTrack.jpg" align="center" width="90%">

## Setup

+ Create environment:
  ```
  git clone https://github.com/xxx/CUTrack.git
  cd CUTrack
  conda create -n CUTrack  python=3.8
  ```

+ Install requirements:
  ```
  pip install -r requirement.txt
  ```

## Training and Testing

To train a category-unified model, you must specify the `.yaml` file with `--cfg` argument.

```
python3.8 main.py  --cfg ./cfgs/SiamCUT.yaml
```

To test a pre-trained model, you must load spedific model with `--checkpoint` and add `--test` flag.

```
python3.8 main.py  --cfg ./cfgs/SiamCUT.yaml --checkpoint ./pretrained_models/siamcut.ckpt --test
```


## Acknowledgement

We acknowledge the excellent implementation from [Open3DSOT](https://github.com/Ghostish/Open3DSOT).