import numpy as np


def general_exponential(
    x: np.ndarray, h: float, p: float
) -> tuple[np.ndarray, np.ndarray, float]:
    N = x.shape[0]
    x_diff = x - x[:, np.newaxis, :]
    pow_x_diff = np.power(np.abs(x_diff), p)
    x_diff_pow_p_minus_1 = np.divide(
        pow_x_diff, x_diff, out=np.zeros_like(pow_x_diff), where=x_diff != 0
    )  # needs x_diff and not abs(x_diff) because of the sign(x-y) in the derivative
    p_dists = np.sum(pow_x_diff, axis=2)
    if h <= 0:
        h = np.median(p_dists[p_dists > 0]) / np.log(N - 1)
    kernel = np.exp(-p_dists / h)
    grad_kernel = np.sum(kernel[..., np.newaxis] * p * x_diff_pow_p_minus_1 / h, axis=0)
    return kernel, grad_kernel, h
