#!/bin/sh

# consider --latent-size=32 or 64 to trade ELBO for generation quality.
python main.py --encoder-activation=identity \
       --decoder-activation=identity \
       --batch-size=16 \
       --conv-normalization=evonorms0 \
       --data-dir=$HOME/datasets/binarized_mnist \
       --task=binarized_mnist \
       --decoder-layer-type=conv \
       --dense-normalization=spectralnorm \
       --encoder-layer-type=tsm_resnet18 \
       --writer-layer-type=conv \
       --writer-conv-normalization=none \
       --writer-dense-normalization=spectralnorm \
       --writer-layer-modifier=none \
       --epochs=100 \
       --kl-beta=1.0 \
       --latent-size=130 \
       --lr=1e-3 \
       --max-image-percentage=1.0 \
       --memory-size=64 \
       --nll-type=bernoulli \
       --optimizer=lars_adam \
       --warmup=10 \
       --lr-update-schedule=cosine \
       --window-size=16 \
       --reparam-type=isotropic_gaussian \
       --encoder-layer-modifier=none \
       --decoder-layer-modifier=none \
       --memory-channels=3 \
       --clip=0 \
       --episode-length=32 \
       --workers-per-replica=8 \
       --monte-carlo-posterior-samples=1 \
       --weight-decay=1e-3 \
       --memory-read-steps=2 \
       --model-dir=./kpp3d/models \
       --log-dir=./kpp3d/logs \
       --num-fixed-point-generation-iterations=10 \
       --uid=kpp3dv01_00v3
