import os
import numpy as np
from sklearn import manifold
from large_rl.commons.seeds import set_randomSeed
from large_rl.commons.args import get_all_args, add_args, _get_emb_file_name
from large_rl.commons.utils import logging

from large_rl.envs.recsim.environments.interest_evolution_generic import create_vector_environment

args = get_all_args()
args.env_name = "recsim"
args.env_seed = 2022
args.recsim_item_dist = "sklearn-gmm"
args.num_all_actions = 30000
args.recsim_dim_tsne_embed = args.recsim_num_categories = args.recsim_dim_embed = 30
args.recsim_sklearnGMM_if_sparse_centroids = True
args.recsim_act_emb_lin_scale, args.recsim_act_emb_lin_shift = 1.0, 1.0

args = vars(add_args(args=args))
set_randomSeed(seed=args["env_seed"])
env = create_vector_environment(args=args)
model = manifold.TSNE(n_components=args["recsim_dim_tsne_embed"], perplexity=4, init="pca",
                      random_state=args["env_seed"], method="exact", n_iter=250)
# embed = model.fit_transform(env.act_embedding)

emb = np.split(ary=env.act_embedding, indices_or_sections=50, axis=0)
embed = list()
for i, _emb in enumerate(emb):
    logging(i, _emb.shape)
    _emb = model.fit_transform(_emb)
    embed.append(_emb)
embed = np.asarray(embed)

logging(embed.shape)

if not os.path.exists("emb"):
    os.makedirs("emb")

_file = _get_emb_file_name(args=args)
logging(_file)
np.save(file=_file, arr=embed)

# import numpy as np
# a = np.load("./emb/seed2022-item5000-tsneDim30-originalDim30.npy")
# a = a.reshape(5000, 30)
# np.save(file="./emb/seed2022-item5000-tsneDim30-originalDim30", arr=a)