from einx._src.error import EinxError

class SemanticError(EinxError):
    def __init__(self, message, invocation=None, pos=None):
        assert isinstance(message, str)
        if invocation is not None:
            self.invocation = invocation
            self.indicator = invocation.indicator
            if isinstance(pos, int):
                self.pos = [pos]
            elif pos is None:
                self.pos = []
            else:
                self.pos = list(pos)
            assert all(p >= 0 and p < len(invocation.expression) for p in self.pos)

            if "%EXPR%" in message:
                message = message.replace("%EXPR%", self.indicator.create(self.pos))
            message += "\n" + invocation.to_call_signature_string()

            self.message = message
        else:
            self.message = message
            self.invocation = None
            self.pos = None

    def __str__(self):
        return self.message