import numpy as _np
import einx._src.tracer as tracer

def _to_tensor(x, np):
    valid_tensor_types = [int, float, bool, _np.integer, _np.floating, _np.bool_, tracer.signature.classical.Tensor]
    if isinstance(np.ndarray, type):
        valid_tensor_types.append(np.ndarray)
    if isinstance(x, tuple(valid_tensor_types)):
        return x
    elif isinstance(x, tracer.signature.classical.ConvertibleTensor):
        if issubclass(x.concrete.type, (list, tuple)):
            shape = x.shape
            x = np.asarray(x)
            x = tracer.cast(x, lambda origin: tracer.signature.classical.Tensor(origin, shape=shape))
            return x
        elif issubclass(x.concrete.type, (int, float, bool, _np.integer, _np.floating, _np.bool_, _np.ndarray)):
            return x
        else:
            raise ValueError(f"An object of type {x.concrete.type} cannot be used as a tensor in PyTorch")
    else:
        raise ValueError(f"Expected a tensor, but got {type(x)}")