from functools import partial
from ._util import _to_tensor

class einsum_from_numpy:
    def __init__(self, np):
        self._np = np
        self._to_tensor = partial(_to_tensor, np=np)

    def __call__(self, subscripts, *operands):
        operands = [self._to_tensor(x) for x in operands]
        return self._np.einsum(subscripts, *operands)