from einx._src.namedtensor import ExpressionIndicator

class EinxError(Exception):
    pass

def _tensor_to_string(tensor):
    if tensor.shape is None:
        return "Tensor factory"
    else:
        return f"Tensor with shape {tensor.shape}"

def _kwarg_to_string(v):
    s = str(v)
    if len(s) < 20:
        return s
    else:
        return "..."

class Invocation:
    def __init__(self, expression, name, tensors, kwargs):
        self.expression = expression
        self.name = name
        self.tensors = tensors
        self.kwargs = kwargs

        self.indicator = ExpressionIndicator(expression)

    def to_call_signature_string(self):
        message = "The operation was called with the following arguments:\n"
        for i, tensor in enumerate(self.tensors):
            message += f"  - Positional argument #{i + 1}: {_tensor_to_string(tensor)}\n"
        for k, v in self.kwargs.items():
            message += f"  - Keyword argument '{k}': {_kwarg_to_string(v)}\n"
        return message