import inspect
import numpy.typing as npt
from ..types import Tensor

def _get_kwargnames(parameters):
    kwargnames = []
    for name, param in parameters.items():
        if param.kind in (inspect.Parameter.KEYWORD_ONLY, inspect.Parameter.VAR_KEYWORD) or param.annotation not in (Tensor, inspect.Parameter.empty):
            kwargnames.append(name)
    return kwargnames

def _adapt_parameters(parameters):
    parameters2 = {}
    parameters2["description"] = inspect.Parameter(
        "description",
        inspect.Parameter.POSITIONAL_OR_KEYWORD,
        annotation=str,
    )
    parameters2.update(parameters)
    parameters2["parameters"] = inspect.Parameter(
        "parameters",
        inspect.Parameter.VAR_KEYWORD,
        annotation=npt.ArrayLike,
    )
    return parameters2