from .api import api
from .types import Tensor
from .backend import Backend
import numpy.typing as npt
from typing import Union, Tuple

@api(use_type_annotations=True)
def id(
    description: str,
    *tensors: Tensor,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Union[Tensor, Tuple[Tensor, ...]]:
    return backend.id(
        description,
        *tensors,
        **parameters,
    )

@api(use_type_annotations=True)
def sum(
    description: str,
    tensor: Tensor,
    *,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.sum(
        description,
        tensor,
        **parameters,
    )

@api(use_type_annotations=True)
def mean(
    description: str,
    tensor: Tensor,
    *,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.mean(
        description,
        tensor,
        **parameters,
    )

@api(use_type_annotations=True)
def var(
    description: str,
    tensor: Tensor,
    *,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.var(
        description,
        tensor,
        **parameters,
    )

@api(use_type_annotations=True)
def std(
    description: str,
    tensor: Tensor,
    *,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.std(
        description,
        tensor,
        **parameters,
    )

@api(use_type_annotations=True)
def prod(
    description: str,
    tensor: Tensor,
    *,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.prod(
        description,
        tensor,
        **parameters,
    )

@api(use_type_annotations=True)
def count_nonzero(
    description: str,
    tensor: Tensor,
    *,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.count_nonzero(
        description,
        tensor,
        **parameters,
    )

@api(use_type_annotations=True)
def any(
    description: str,
    tensor: Tensor,
    *,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.any(
        description,
        tensor,
        **parameters,
    )

@api(use_type_annotations=True)
def all(
    description: str,
    tensor: Tensor,
    *,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.all(
        description,
        tensor,
        **parameters,
    )

@api(use_type_annotations=True)
def max(
    description: str,
    tensor: Tensor,
    *,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.max(
        description,
        tensor,
        **parameters,
    )

@api(use_type_annotations=True)
def min(
    description: str,
    tensor: Tensor,
    *,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.min(
        description,
        tensor,
        **parameters,
    )

@api(use_type_annotations=True)
def logsumexp(
    description: str,
    tensor: Tensor,
    *,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.logsumexp(
        description,
        tensor,
        **parameters,
    )

@api(use_type_annotations=True)
def dot(
    description: str,
    *tensors: Tensor,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.dot(
        description,
        *tensors,
        **parameters,
    )

@api(use_type_annotations=True)
def add(
    description: str,
    *tensors: Tensor,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.add(
        description,
        *tensors,
        **parameters,
    )

@api(use_type_annotations=True)
def subtract(
    description: str,
    *tensors: Tensor,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.subtract(
        description,
        *tensors,
        **parameters,
    )

@api(use_type_annotations=True)
def multiply(
    description: str,
    *tensors: Tensor,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.multiply(
        description,
        *tensors,
        **parameters,
    )

@api(use_type_annotations=True)
def true_divide(
    description: str,
    *tensors: Tensor,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.true_divide(
        description,
        *tensors,
        **parameters,
    )

@api(use_type_annotations=True)
def floor_divide(
    description: str,
    *tensors: Tensor,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.floor_divide(
        description,
        *tensors,
        **parameters,
    )

@api(use_type_annotations=True)
def divide(
    description: str,
    *tensors: Tensor,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.divide(
        description,
        *tensors,
        **parameters,
    )

@api(use_type_annotations=True)
def logical_and(
    description: str,
    *tensors: Tensor,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.logical_and(
        description,
        *tensors,
        **parameters,
    )

@api(use_type_annotations=True)
def logical_or(
    description: str,
    *tensors: Tensor,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.logical_or(
        description,
        *tensors,
        **parameters,
    )

@api(use_type_annotations=True)
def logical_xor(
    description: str,
    *tensors: Tensor,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.logical_xor(
        description,
        *tensors,
        **parameters,
    )

@api(use_type_annotations=True)
def where(
    description: str,
    mask: Tensor,
    x: Tensor,
    y: Tensor,
    *,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.where(
        description,
        mask,
        x,
        y,
        **parameters,
    )

@api(use_type_annotations=True)
def maximum(
    description: str,
    *tensors: Tensor,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.maximum(
        description,
        *tensors,
        **parameters,
    )

@api(use_type_annotations=True)
def minimum(
    description: str,
    *tensors: Tensor,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.minimum(
        description,
        *tensors,
        **parameters,
    )

@api(use_type_annotations=True)
def less(
    description: str,
    *tensors: Tensor,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.less(
        description,
        *tensors,
        **parameters,
    )

@api(use_type_annotations=True)
def less_equal(
    description: str,
    *tensors: Tensor,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.less_equal(
        description,
        *tensors,
        **parameters,
    )

@api(use_type_annotations=True)
def greater(
    description: str,
    *tensors: Tensor,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.greater(
        description,
        *tensors,
        **parameters,
    )

@api(use_type_annotations=True)
def greater_equal(
    description: str,
    *tensors: Tensor,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.greater_equal(
        description,
        *tensors,
        **parameters,
    )

@api(use_type_annotations=True)
def equal(
    description: str,
    *tensors: Tensor,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.equal(
        description,
        *tensors,
        **parameters,
    )

@api(use_type_annotations=True)
def not_equal(
    description: str,
    *tensors: Tensor,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.not_equal(
        description,
        *tensors,
        **parameters,
    )

@api(use_type_annotations=True)
def logaddexp(
    description: str,
    *tensors: Tensor,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.logaddexp(
        description,
        *tensors,
        **parameters,
    )

@api(use_type_annotations=True)
def get_at(
    description: str,
    *tensors: Tensor,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.get_at(
        description,
        *tensors,
        **parameters,
    )

@api(use_type_annotations=True)
def set_at(
    description: str,
    *tensors: Tensor,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.set_at(
        description,
        *tensors,
        **parameters,
    )

@api(use_type_annotations=True)
def add_at(
    description: str,
    *tensors: Tensor,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.add_at(
        description,
        *tensors,
        **parameters,
    )

@api(use_type_annotations=True)
def subtract_at(
    description: str,
    *tensors: Tensor,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.subtract_at(
        description,
        *tensors,
        **parameters,
    )

@api(use_type_annotations=True)
def softmax(
    description: str,
    tensor: Tensor,
    *,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.softmax(
        description,
        tensor,
        **parameters,
    )

@api(use_type_annotations=True)
def log_softmax(
    description: str,
    tensor: Tensor,
    *,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.log_softmax(
        description,
        tensor,
        **parameters,
    )

@api(use_type_annotations=True)
def sort(
    description: str,
    tensor: Tensor,
    *,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.sort(
        description,
        tensor,
        **parameters,
    )

@api(use_type_annotations=True)
def argsort(
    description: str,
    tensor: Tensor,
    *,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.argsort(
        description,
        tensor,
        **parameters,
    )

@api(use_type_annotations=True)
def flip(
    description: str,
    tensor: Tensor,
    *,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.flip(
        description,
        tensor,
        **parameters,
    )

@api(use_type_annotations=True)
def roll(
    description: str,
    tensor: Tensor,
    *,
    shift: npt.ArrayLike,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.roll(
        description,
        tensor,
        shift=shift,
        **parameters,
    )

@api(use_type_annotations=True)
def argmax(
    description: str,
    tensor: Tensor,
    *,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.argmax(
        description,
        tensor,
        **parameters,
    )

@api(use_type_annotations=True)
def argmin(
    description: str,
    tensor: Tensor,
    *,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Tensor:
    return backend.argmin(
        description,
        tensor,
        **parameters,
    )

ops = [
    globals()[name] for name in dir() if name[0].islower() and name not in ["all", "api", "npt"] and callable(globals()[name])
]