import warnings
from typing import Tuple, Union
import numpy.typing as npt
from .ops import id
from .backend import Backend
from .types import Tensor

class RemovedOperationError(Exception):
    pass

def vmap(*args, **kwargs):
    raise RemovedOperationError("einx.vmap has been removed since version 0.4.0. Please use einx-adapters instead. See TODO")

def vmap_with_axis(*args, **kwargs):
    raise RemovedOperationError("einx.vmap_with_axis has been removed since version 0.4.0. Please use einx-adapters instead. See TODO")

def reduce(*args, **kwargs):
    raise RemovedOperationError("einx.reduce has been removed since version 0.4.0. Please use einx-adapters instead. See TODO")

def elementwise(*args, **kwargs):
    raise RemovedOperationError("einx.elementwise has been removed since version 0.4.0. Please use einx-adapters instead. See TODO")

def arange(*args, **kwargs):
    raise RemovedOperationError("einx.arange has been removed since version 0.4.0. Please use einx.id instead. See TODO")

def rearrange(
    description: str,
    *tensors: Tensor,
    backend: Union[Backend, str, None] = None,
    **parameters: npt.ArrayLike,
) -> Union[Tensor, Tuple[Tensor, ...]]:
    warnings.warn(
        "einx.rearrange is deprecated and will be removed in a future release. Please use einx.id instead.",
        DeprecationWarning,
        stacklevel=2,
    )
    return id(description, *tensors, backend=backend, **parameters)