from .. import ExpressionIndicator
from einx._src.error import EinxError

class SyntaxError(EinxError):
    def __init__(self, expression, message, pos=None):
        if not isinstance(expression, str):
            raise ValueError("expression must be a string")
        self.expression = expression
        self.indicator = ExpressionIndicator(expression)
        if isinstance(pos, int):
            self.pos = [pos]
        elif pos is None:
            self.pos = []
        else:
            self.pos = list(pos)
        assert all(p >= 0 and p < len(expression) for p in self.pos)

        if "%EXPR%" in message:
            message = message.replace("%EXPR%", self.indicator.create(self.pos))

        self.message = message

    def __str__(self):
        return self.message
