from einx._src.error import EinxError

class RankError(EinxError):
    def __init__(self, invocation, message, pos=None, constraints=[]):
        self.invocation = invocation
        self.indicator = invocation.indicator
        if isinstance(pos, int):
            self.pos = [pos]
        elif pos is None:
            self.pos = []
        else:
            self.pos = list(pos)
        assert all(p >= 0 and p < len(invocation.expression) for p in self.pos)

        self.constraints = []
        for constraint in constraints:
            if isinstance(constraint, str):
                self.constraints.append(constraint)
            else:
                assert len(constraint) == 2
                if constraint[0] is not None and constraint[1] is not None:
                    self.constraints.append(f"{constraint[0]} = {constraint[1]}")

        if "%EXPR%" in message:
            message = message.replace("%EXPR%", self.indicator.create(self.pos))
        if len(self.constraints) > 0:
            message += "\nThe following equation(s) were determined for the expression:"
            for constraint in self.constraints:
                message += f"\n    {constraint}"
        message += "\n" + invocation.to_call_signature_string()

        self.message = message

    def __str__(self):
        return self.message