import functools

def _get_name(op):
    if isinstance(op, str):
        return op
    elif isinstance(op, functools.partial):
        return _get_name(op.func)
    elif hasattr(op, "__name__"):
        return op.__name__
    else:
        return None

def use_name_of(signature_op):
    name = _get_name(signature_op)
    def inner(op):
        if name is None:
            return op
        else:
            def inner(*args, **kwargs):
                return op(*args, **kwargs)
            inner.__name__ = name
            return inner
    return inner