#include <torch/extension.h>

#include <vector>

// CUDA forward declarations

std::vector<torch::Tensor> facs_fbs_cuda_forward(
    const int n_topk,
    torch::Tensor input,
    torch::Tensor topk_score,
    torch::Tensor indices);

std::vector<torch::Tensor> facs_fbs_cuda_backward(
    const int n_topk,
    torch::Tensor input,
    torch::Tensor topk_score,
    torch::Tensor indices,
    torch::Tensor output_grad);

// C++ interface

#define CHECK_CUDA(x) TORCH_CHECK(x.device().is_cuda(), #x " must be a CUDA tensor")
#define CHECK_CONTIGUOUS(x) TORCH_CHECK(x.is_contiguous(), #x " must be contiguous")
#define CHECK_INPUT(x) CHECK_CUDA(x); CHECK_CONTIGUOUS(x)

std::vector<torch::Tensor> facs_fbs_forward(
    const int n_topk,
    torch::Tensor input,
    torch::Tensor topk_score,
    torch::Tensor indices)
{
  CHECK_INPUT(input);
  CHECK_INPUT(topk_score);
  CHECK_INPUT(indices);

  return facs_fbs_cuda_forward(n_topk, input, topk_score, indices);
}

std::vector<torch::Tensor> facs_fbs_backward(
  const int n_topk,
    torch::Tensor input,
    torch::Tensor topk_score,
    torch::Tensor indices,
    torch::Tensor output_grad) {

  CHECK_INPUT(input);
  CHECK_INPUT(topk_score);
  CHECK_INPUT(indices);
  CHECK_INPUT(output_grad);

  return facs_fbs_cuda_backward(n_topk, input, topk_score, indices,  output_grad);
}

PYBIND11_MODULE(TORCH_EXTENSION_NAME, m)
 {
  m.def("forward", &facs_fbs_forward, "FACS fbs forward (CUDA)");
  m.def("backward", &facs_fbs_backward, "FACS fbs backward (CUDA)");
}
