#include <torch/extension.h>

#include <vector>

// CUDA forward declarations

std::vector<torch::Tensor> facs_cuda_forward(
    const int k_size,
    const float FACS_THRESH,
    torch::Tensor input,
    torch::Tensor fusion_prob);

std::vector<torch::Tensor> facs_cuda_backward(
    const int k_size,
    float FACS_THRESH,
   torch::Tensor input,
    torch::Tensor fusion_prob,
    torch::Tensor output_grad);

// C++ interface

#define CHECK_CUDA(x) TORCH_CHECK(x.device().is_cuda(), #x " must be a CUDA tensor")
#define CHECK_CONTIGUOUS(x) TORCH_CHECK(x.is_contiguous(), #x " must be contiguous")
#define CHECK_INPUT(x) CHECK_CUDA(x); CHECK_CONTIGUOUS(x)

std::vector<torch::Tensor> facs_forward(
    const int k_size,
    float FACS_THRESH,
    torch::Tensor input,
     torch::Tensor fusion_prob)
{
  CHECK_INPUT(input);
  CHECK_INPUT(fusion_prob);
  return facs_cuda_forward(k_size, FACS_THRESH, input, fusion_prob);
}

std::vector<torch::Tensor> facs_backward(
  const int k_size,
  float FACS_THRESH,
  torch::Tensor input,
  torch::Tensor fusion_prob,
  torch::Tensor output_grad) {

  CHECK_INPUT(input);
  CHECK_INPUT(fusion_prob);
  CHECK_INPUT(output_grad);

  return facs_cuda_backward(
    k_size, FACS_THRESH,
    input,
    fusion_prob,
    output_grad);
}

PYBIND11_MODULE(TORCH_EXTENSION_NAME, m)
 {
  m.def("forward", &facs_forward, "FACS forward (CUDA)");
  m.def("backward", &facs_backward, "FACS backward (CUDA)");
}
