# XGRAG: A Graph-native Framework for Explaining KG-based Retrieval-Augmented Generation (RAG) Systems

This repository contains the official implementation for the paper: **XGRAG: A Graph-native Framework for Explaining KG-based Retrieval-Augmented Generation (RAG) Systems**.

Our work introduces XGRAG, a model-agnostic framework for explaining reasoning process of GraphRAG systems. By applying graph-native perturbations, XGRAG identifies the nodes and edges most critical to the model's answer generation process.

## Key Features
- **Graph-Native Explanations**: Generates explanations by perturbing graph components (nodes, edges) directly.
- **Model-Agnostic**: Compatible with a wide range of open-source LLMs (Gemma, Llama, Mistral, etc.).
- **Multiple Perturbation Strategies**: Includes Node Removal, Edge Removal, and Synonym Injection to provide a comprehensive analysis.
- **Robust Evaluation**: Implements a full suite of metrics for explanation accuracy, ranking quality, and structural alignment.

## Repository Structure

A clean, self-contained structure is used for this project to ensure clarity and reproducibility.

```
xai-framework/
├── README.md
├── requirements.txt
├── config_template.yaml
├── src/xgrag/          # Main framework source code
├── scripts/            # Experiment and evaluation scripts
├── scripts/LightRAG/   # Builds upon LightRAG official repo: https://github.com/HKUDS/LightRAG (version 1.4.4)
```

## Environment Set-up
### 0. Prerequisites

Before you begin, ensure you have the following installed on your system:

*   **Python=3.10**
*   **Ollama=0.11.4**
    
### 1. Installation

#### 1.1 Create a virtual environment for XGRAG:
```
conda create -n xgrag python=3.10
conda activate xgrag
```
#### 1.2 Install the required dependencies:
```bash
pip install -r requirements.txt
```

## Reproducing the Results

### 2.1 Launch ollama services
```
ollama serve
```

### 2.2 Configure the experiment
Before running the experiment, you need to create a `config.yaml` file to specify the parameters. You can create this file from the provided template `config_template.yaml`.

### 2.3 Run the experiment script
```
cd scripts/
python run_xgrag_experiment.py
```
(ensuring `PYTHONPATH='./scripts/LightRAG'`)

### 2.4 Run the evaluation script
After running the experiment script (`run_xgrag_experiment.py`), an experiment-specific directory `experiment_dir` is created inside the `working_dir` you specified in `config.yaml`. You will need to provide the path to this directory to the evaluation script.

To run the evaluation, execute the following command, replacing `<path_to_your_experiment_directory>` with the actual path to your experiment's output directory `experiment_dir`:

```bash
cd scripts/
python run_xgrag_evaluation.py <path_to_your_experiment_directory>
```

The evaluation script will analyze the results within that directory and save the explanation outputs (`explainer_results_final.txt`) back into the same experiment directory.

## 📚 Citation & Acknowledgements

This repository builds upon the following open-source implementations:

### 🔹 LightRAG

We use the [LightRAG](https://github.com/HKUDS/LightRAG) framework (**version 1.4.4**) as the core implementation for our GraphRAG backbone, including its modular design for retrievers and generators.

> **LightRAG: Simple and Fast Retrieval-Augmented Generation**  
> Zirui Guo, Lianghao Xia, Yanhua Yu, Tu Ao, Chao Huang  
> [arXiv:2410.05779](https://arxiv.org/abs/2410.05779)  
> GitHub Repository: [https://github.com/HKUDS/LightRAG](https://github.com/HKUDS/LightRAG)

### 🔹 RAG-Ex

Part of our modules under `/src/xgrag/explainer` are adapted from the [RAG-Ex framework](https://github.com/fraunhofer-iais/explainable-lms).

> **RAG-Ex: A Generic Framework for Explaining Retrieval Augmented Generation**  
> Viju Sudhi, Sinchana Ramakanth Bhat, Max Rudat, Roman Teucher  
> In *Proceedings of the 47th International ACM SIGIR Conference on Research and Development in Information Retrieval (SIGIR ’24)*  
> [https://doi.org/10.1145/3626772.3657660](https://doi.org/10.1145/3626772.3657660)  
> GitHub Repository: [https://github.com/fraunhofer-iais/explainable-lms](https://github.com/fraunhofer-iais/explainable-lms)
 
## 📜 Licensing
This project builds upon open-source frameworks. For transparency and compliance, the licenses for the core dependencies, including LightRAG and RAG-Ex, are provided in the `LICENSES` folder.
Please refer to the respective files within that directory for full details on the terms and conditions of their use.