from typing import List
import os
os.environ["NO_PROXY"] = '127.0.0.1,localhost'
os.environ['no_proxy'] = '127.0.0.1,localhost' 
from ollama._client import Client

class Encoder:
    """
    A wrapper for encoding text into vector embeddings.
    """
    def __init__(
        self,
        model_name: str,
    ):
        """
        Initializes the Encoder.
        
        Args:
            model_name: The name of the embedding model to use.
        """
        self.__model_name = model_name
        self.__client = self.__get_client()

    def encode(self, texts: List[str]) -> List[List[float]]:
        """
        Generates embeddings for a list of texts.
        """
        try:
            return self.__client.embed(
                            model=self.__model_name,
                            input=texts,
                        )['embeddings']
        except Exception as e:
            raise ValueError(f"Failed to get embeddings for model '{self.__model_name}': {e}")
        
    def __get_client(self):
        return Client(host='127.0.0.1')