# Chain of Thought Order Code

This project explores the impact of data order on the performance of language models, using global and local search methods to find optimal permutations.

## 1. Environment Setup

The recommended way to set up the environment is by using Docker and Docker Compose.

### Prerequisites

*   [Docker](https://docs.docker.com/get-docker/)
*   [NVIDIA Container Toolkit](https://docs.nvidia.com/datacenter/cloud-native/container-toolkit/latest/install-guide.html) for GPU support.

### Configuration

1.  **Edit `docker-compose.yml`**:

    You need to replace the placeholder volume paths with the absolute path to this project directory on your local machine.

    ```yaml
    # docker-compose.yml
    services:
      gpu_service:
        ...
        volumes:
          - /your-path:/app:rw # <-- CHANGE THIS
          - /your-path/data:/app/data:rw # <-- AND THIS
        ...
    ```

    For example, if you cloned the repository to `/home/user/chain-of-though-order-code`, change it to:

    ```yaml
    # docker-compose.yml
    services:
      gpu_service:
        ...
        volumes:
          - /home/user/chain-of-though-order-code:/app:rw
          - /home/user/chain-of-though-order-code/data:/app/data:rw
        ...
    ```

2.  **Build and Run the Container**:

    Open a terminal in the project root and run:

    ```bash
    docker-compose up -d --build
    ```

3.  **Access the Container**:

    You can get a shell inside the running container with:

    ```bash
    docker exec -it iclr26-your-container-name /bin/bash
    ```
    *(Note: You can change `iclr26-your-container-name` in `docker-compose.yml`)*

## 2. Dataset Generation

The scripts to generate datasets are located in the `sh/dataset/` directory. Run these from within the Docker container.

### Index Dataset

```bash
bash sh/dataset/run_index.sh
```

### ReLU Dataset

```bash
bash sh/dataset/run_relu.sh
```

### Square Dataset

```bash
bash sh/dataset/run_square.sh
```

The generated datasets will be saved under the `data/data/small/` directory.

## 3. Running Exploration Methods

The scripts for running the global and local permutation search are in the `sh/` directory.

**Before running**, you may need to configure the parameters at the top of each script (e.g., `gpu_id`, `DATASET_BASE_NAME`, `TARGET_LEN`).

### Global Search

This method uses a genetic algorithm to explore the permutation space more broadly.

```bash
bash sh/run_exploration_global.sh
```

The script will run in the background, and logs will be saved to `log.txt` in the specified `OUTPUT_DIR`.

### Local Search

This method performs a more focused, local search for optimal permutations.

```bash
bash sh/run_exploration_local.sh
```

Similar to the global search, this script runs in the background and logs its output.
