#!/bin/bash

# Temporary output directory (local)
TEMP_OUTPUT_DIR="data/data/small/relu"

# List of sequence lengths
SEQUENCE_LENGTHS=(25 30 35 40 45)

# List of sample numbers
SAMPLE_SIZES=(100000)

# Create a temporary directory
# rm -rf "$TEMP_OUTPUT_DIR"  # Delete existing temporary directory
mkdir -p "$TEMP_OUTPUT_DIR"

# Generate a dataset for each combination of sequence length and number of samples
for seq_len in "${SEQUENCE_LENGTHS[@]}"; do
    for num_samples in "${SAMPLE_SIZES[@]}"; do
        # Create a directory for each sequence length
        seq_dir="${TEMP_OUTPUT_DIR}/n=${seq_len}"
        mkdir -p "$seq_dir"

        # Generate training dataset
        python3 src/data/reludataset.py \
            --num_samples $num_samples \
            --sequence_length $seq_len \
            --output_file "data.train" \
            --output_dir "$seq_dir" \
            --seed 42 

        # Generate test dataset
        python3 src/data/reludataset.py \
            --num_samples 1000 \
            --sequence_length $seq_len \
            --output_file "data.test" \
            --output_dir "$seq_dir" \
            --seed 123

        # # Generate training dataset
        # python3 src/data/reludataset.py \
        #     --num_samples $num_samples \
        #     --sequence_length $seq_len \
        #     --output_file "data-inv.train" \
        #     --output_dir "$seq_dir" \
        #     --seed 42 \
        #     --inverse

        # # Generate test dataset
        # python3 src/data/reludataset.py \
        #     --num_samples 1000 \
        #     --sequence_length $seq_len \
        #     --output_file "data-inv.test" \
        #     --output_dir "$seq_dir" \
        #     --seed 123 \
        #     --inverse

        # # Generate random training dataset
        # python3 src/data/reludataset.py \
        #     --num_samples $num_samples \
        #     --sequence_length $seq_len \
        #     --output_file "data-rand.train" \
        #     --output_dir "$seq_dir" \
        #     --seed 42 \
        #     --permutation "10,6,16,4,18,12,15,2,19,14,9,5,3,1,8,7,13,0,17,11"

        # # Generate random training dataset
        # python3 src/data/reludataset.py \
        #     --num_samples 1000 \
        #     --sequence_length $seq_len \
        #     --output_file "data-rand.test" \
        #     --output_dir "$seq_dir" \
        #     --seed 123 \
        #     --permutation "10,6,16,4,18,12,15,2,19,14,9,5,3,1,8,7,13,0,17,11"

        # # Generate two permutation training datasets
        # python3 src/data/reludataset.py \
        #     --num_samples $num_samples \
        #     --sequence_length $seq_len \
        #     --output_file "data-one.train" \
        #     --output_dir "$seq_dir" \
        #     --seed 42 \
        #     --permutation "0,1,2,3,4,5,6,7,8,10,9,11,12,13,14,15,16,17,18,19"

        # # Generate two permutation training datasets
        # python3 src/data/reludataset.py \
        #     --num_samples 1000 \
        #     --sequence_length $seq_len \
        #     --output_file "data-one.test" \
        #     --output_dir "$seq_dir" \
        #     --seed 123 \
        #     --permutation "0,1,2,3,4,5,6,7,8,10,9,11,12,13,14,15,16,17,18,19"

        # # Generate two permutation training datasets
        # python3 src/data/reludataset.py \
        #     --num_samples $num_samples \
        #     --sequence_length $seq_len \
        #     --output_file "data.train" \
        #     --output_dir "$seq_dir" \
        #     --seed 42 \
        #     --permutation "0,1,2,3,4,5,6,7,8,9"

        # # Generate two permutation training datasets
        # python3 src/data/reludataset.py \
        #     --num_samples 1000 \
        #     --sequence_length $seq_len \
        #     --output_file "data.test" \
        #     --output_dir "$seq_dir" \
        #     --seed 123 \
        #     --permutation "0,1,2,3,4,5,6,7,8,9"

    done
done

echo "Dataset generation is complete. Temporary directory: $TEMP_OUTPUT_DIR"