#!/bin/bash
# (sleep 3h; bash /path/to/run.sh) &

# Move to the directory where the script exists (optional)
# cd "$(dirname "$0")"

# --- Settings --- #

# Path to the directory where the model is stored
# Example: "./models/my_gpt_model"
# MODEL_PATH="/mnt/nfs/results/small/relu/relu_gpt2_digits=50_bs=128_inverse"
# MODEL_PATH="/mnt/nfs/results/small/relu/relu_n=50_perm32_target50_prefix50_1epochs"
# MODEL_PATH="/mnt/nfs/results/small/square_mod19/square_gpt2_mod19_L=6_digits=50_bs=128_inverse"
# MODEL_PATH="/mnt/nfs/results/small/index/index_gpt2_longlearning_L=6_digits=13_m=4_bs=128_inverse"
# MODEL_PATH="/mnt/nfs/results/small/relu/relu_gpt2_single_layer_digits=50_bs=128_inverse"
# MODEL_PATH="/mnt/nfs/results/small/square_mod19/square_gpt2_mod19_digits=20_bs=128_inverse"
# MODEL_PATH="/mnt/nfs/results/small/index/index_gpt2_longlearning_L=6_digits=13_m=4_bs=128_inverse"
MODEL_PATH="/mnt/nfs/results/small/square_mod19/square_mod19_n=50_perm32_target50_prefix50_1epochs"

# Checkpoint ID to use (if not specified, the latest one will be used)
# Example: "10000" or "None" (If None, it is assumed to be treated as None in the script, but omitted as an argument)
# CHECKPOINT_ID="31280"
# CHECKPOINT_ID="1564" 
# CHECKPOINT_ID="1580"
CHECKPOINT_ID="782"
# CHECKPOINT_ID="31280"
# Path to the evaluation dataset
# Example: "./data/my_test_dataset.jsonl"
# DATASET_PATH="/mnt/nfs/data/small/relu/n=50/data.test"
DATASET_PATH="/mnt/nfs/data/small/square_mod19/n=50/data.test"
# DATASET_PATH="/mnt/nfs/data/small/index/n=13_m=4/data.test"
# DATASET_PATH="/mnt/nfs/data/small/square_mod19/n=50/data.test"
# DATASET_PATH="/mnt/nfs/data/small/index/n=13_m=4/data.test"
INPUT_LEN=50
CANDIDATE_RANK=5
TARGET_LAYER=0

# Batch size for evaluation
BATCH_SIZE=1000 # Please adjust according to memory

VISUALIZE_ATTENTION=true

# Specific input text to visualize (if not specified, the first few samples will be targeted)
# Example: "translate English to Japanese: Hello world."
TARGET_INPUT_TEXT=""

# Maximum number of tokens when generating text with the forward method (excluding input length)
MAX_OUTPUT_LENGTH=101

# Transformer layer number to visualize and analyze attention
# (Index starting from 0, -1 means the last layer)

# --- Execution command --- #

# python command (change to python3 etc. according to your environment)
PYTHON_CMD="python3"

# Script path
SCRIPT_PATH="src/evaluation_gpt_forward.py"

CMD="CUDA_VISIBLE_DEVICES=2 $PYTHON_CMD $SCRIPT_PATH \
    --model_path $MODEL_PATH \
    --dataset_path $DATASET_PATH \
    --batch_size $BATCH_SIZE \
    --max_output_length $MAX_OUTPUT_LENGTH \
    --target_layer $TARGET_LAYER \
    --input_len $INPUT_LEN \
    --candidate_rank $CANDIDATE_RANK"

# Add if checkpoint ID is specified
if [ ! -z "$CHECKPOINT_ID" ]; then
    CMD="$CMD --checkpoint_id $CHECKPOINT_ID"
fi

# Add a flag if attention visualization is true
if [ "$VISUALIZE_ATTENTION" = true ]; then
    CMD="$CMD --visualize_attention"
fi

# Add if specific input text is specified
if [ ! -z "$TARGET_INPUT_TEXT" ]; then
    CMD="$CMD --target_input_text \"$TARGET_INPUT_TEXT\""
fi

# Execute the assembled command
echo "Execution command:"
echo "$CMD"
echo " "

eval $CMD

echo " "
echo "Execution of the evaluation script is complete."