#!/bin/bash

# Path to configuration file
base_path="/mnt/nfs/results/large/prod_padding/"
cfg_path="${base_path}prod_padding_cross_self_attn_singlehead_ZZ_digits=5_standard_bs=128_inverse/params.yaml"
# base_path="/mnt/nfs/results/large/gray_decode/"
# cfg_path="${base_path}gray_decode_self_cross_attn_singlehead_digits=100_bs=128/params.yaml"
# Multiplication example (one example only)
# input_seq="0 4 6 4 6 [SEP] 0 0 0 4 8"
input_seq="0 0 1 2 7 [SEP] 3 4 0 3 1"
# input_seq="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 1 1 1 0 0 1 0 0 0 1 0"
# input_seq="0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 0 0 1 0 0 0 1 0 1 1 0 1 1 1 0 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1"
# Layer range to visualize
layer_range="0,1,2,3,4,5"

# Maximum output length
max_length=10

echo "========================================"
echo "Execution settings:"
echo "Configuration file: $cfg_path"
echo "Input sequence: $input_seq"
echo "Layer range: $layer_range"
echo "Maximum output length: $max_length"
echo "========================================"
echo "* Collected during model's greedy_generate execution"
echo "* self.inference_attn_map [layer_num, head_num, tokens_length, encoder_token_length]"
echo "* Use to visualize the average attention map for all heads for each layer"
echo "========================================"

# Execute
CUDA_VISIBLE_DEVICES=0 python3 src/attnmap_vis.py \
    --cfg-path "$cfg_path" \
    --input-seq "$input_seq" \
    --layer-range "$layer_range" \
    --max-length "$max_length"

echo "========================================"
echo "Attention map visualization is complete"
echo "The average attention map for all heads of each layer is saved"
echo "An average attention map for all layers was also generated"
echo "========================================