#!/bin/bash

# Path to configuration file
base_path="/mnt/nfs/results/large/prod_padding/"
cfg_path="${base_path}prod_padding_no_self_attn_ZZ_digits=5_standard_bs=128/params.yaml"

# Multiplication example (one example only)
input_seq="0 4 6 4 6 [SEP] 0 0 0 4 8"

# Layer range to visualize
layer_range="0,2,5"

# Maximum output length
max_length=10

echo "========================================"
echo "Execution settings:"
echo "Configuration file: $cfg_path"
echo "Input sequence: $input_seq"
echo "Layer range: $layer_range"
echo "Maximum output length: $max_length"
echo "========================================"
echo "* Visualize self-attention and cross-attention maps for each layer"
echo "* Get from model.decoder.layers[??].self_attn_weights and"
echo "* model.decoder.layers[??].cross_attn_weights"
echo "* Color display: matplotlib colormap with min=blue(0), mid=red, max=green(0.5)"
echo "========================================"

# Execute
CUDA_VISIBLE_DEVICES=0 python3 src/attnmap_vis.py \
    --cfg-path "$cfg_path" \
    --input-seq "$input_seq" \
    --layer-range "$layer_range" \
    --max-length "$max_length"

echo "========================================"
echo "Attention map visualization is complete"
echo "Self-attention and cross-attention maps for each layer are saved"
echo "======================================== "