#!/bin/bash

# Path to configuration file
base_path="/mnt/nfs/results/large/prod_padding/"
cfg_path="${base_path}prod_padding_no_self_attn_ZZ_digits=5_standard_bs=128/params.yaml"

# Multiplication example (one example only)
input_seq="0 4 6 4 6 [SEP] 0 0 0 4 8"

# Layer range to analyze
layer_range="0,2,5"

# Maximum output length
max_length=10

# Number of top contributing encoder tokens to display for each token
top_k=3

echo "========================================"
echo "Execution settings:"
echo "Configuration file: $cfg_path"
echo "Input sequence: $input_seq"
echo "Layer range: $layer_range"
echo "Maximum output length: $max_length"
echo "Top-K to display: $top_k"
echo "========================================"
echo "* During model's greedy_generate execution, for each generation step"
echo "* self.inference_attn_map [layer_num, head_num, tokens_length, encoder_token_length]"
echo "* Accumulate and visualize attention maps for each layer and head"
echo "========================================"

# Execute
CUDA_VISIBLE_DEVICES=0 python3 src/encoder_contribution_vis.py \
    --cfg-path "$cfg_path" \
    --input-seq "$input_seq" \
    --layer-range "$layer_range" \
    --max-length "$max_length" \
    --top-k "$top_k"

echo "========================================"
echo "Encoder contribution visualization is complete"
echo "Detailed attention maps for each layer and head are saved"
echo "========================================